﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Linq.Dynamic;
using System.Data;
using VeteransAffairs.Registries.Business;

namespace VeteransAffairs.Registries.BusinessManager
{
    [Serializable()]
    [System.ComponentModel.DataObject]
    public class ReferenceRangeManager : BaseBO
    {
        #region Constructor

        public ReferenceRangeManager()
        {
           // _defaultSortField = "";
        }
        
        #endregion

        #region LINQ queries

        /// <summary>
        /// Returns iqueryable of all reference ranges.
        /// </summary>
        /// <param name="RegistryCode"></param>
        /// <returns></returns>
        private IQueryable<STD_ANALYTE_TEST_REFERENCE_RANGE> LinqAll()
        {
            //populate LinqAll
            IQueryable<STD_ANALYTE_TEST_REFERENCE_RANGE> ReferenceRanges = (from e in _db.STD_ANALYTE_TEST_REFERENCE_RANGEs
                                      select e);
            
            return ReferenceRanges;
        }



        private IQueryable<STD_ANALYTE_TEST_REFERENCE_RANGE> SelectByIDLinqFilter(int ID)
        {

            return (from e in LinqAll()
                    where e.ID==ID
                    select e);
        
        }



        //private IQueryable<ReferenceRangeView> SelectReferenceRangesLinqFilter()
        //{
        
        //return (from e in LinqAll() 
        //    select new ReferenceRangeView
        //    {
        //        ID = e.ID,
        //        AnalyteName = e.STD_ANALYTETYPE.NAME,
        //        TEFSCReferenceRange = e.REFERENCE_RANGE,
        //        TestName = e.STD_TEST_NAME.NAME,
        //        UnitID = e.STD_UNITS_ID,
        //        UnitName = e.STD_UNIT.NAME
        //    });
        //}

        //private IQueryable<ReferenceRangeView> SelectReferenceRangeByIDLinqFilter(int ID)
        //{

        //    return (from e in LinqAll()
        //            where e.ID == ID
        //            select new ReferenceRangeView
        //            {
        //                ID = e.ID,
        //                AnalyteName = e.STD_ANALYTETYPE.NAME,
        //                TEFSCReferenceRange = e.REFERENCE_RANGE,
        //                TestName = e.STD_TEST_NAME.NAME,
        //                UnitID = e.STD_UNITS_ID,
        //                UnitName = e.STD_UNIT.NAME
        //            });
        //}

        #endregion

        #region Methods for Select 

        /// <summary>
        /// Return a list of all reference ranges
        /// </summary>
        /// <returns></returns>
        //public IEnumerable<STD_ANALYTE_TEST_REFERENCE_RANGE> Select()
        //{
        //    using (_db = GetDataContext())
        //    {
        //        //SetLoadWith(_db);
        //        return LinqAll().ToList();
        //    }
        //}

        public IEnumerable<ReferenceRangeView> SelectReferenceRanges()
        {
            using (_db = GetDataContext())
            {
                return (from e in LinqAll()
                        select new ReferenceRangeView
                        {
                            ID = e.ID,
                            AnalyteName = e.STD_ANALYTETYPE.NAME,
                            TEFSCReferenceRange = e.REFERENCE_RANGE,
                            TestName = e.STD_TEST_NAME.NAME,
                            UnitID = e.STD_UNITS_ID,
                            UnitName = e.STD_UNIT.NAME
                        }).ToList();
            }
        }

        public ReferenceRangeView SelectReferenceRangeByID(int ID)
        {
             using (_db = GetDataContext())
            {
                //SetLoadWith(_db);

                return (from e in SelectByIDLinqFilter(ID)
                        
                        select new ReferenceRangeView
                        {
                            ID = e.ID,
                            AnalyteName = e.STD_ANALYTETYPE.NAME,
                            TEFSCReferenceRange = e.REFERENCE_RANGE,
                            TestName = e.STD_TEST_NAME.NAME,
                            UnitID = e.STD_UNITS_ID,
                            UnitName = e.STD_UNIT.NAME
                        }).FirstOrDefault();                 
            }
        }

        #endregion

        #region Methods for Update

        public void UpdateReferenceRange(ReferenceRangeView RefRange)
        {
            //Retrieve the LINQ entitiy, update the values and save it

            //1. get my linq object

            STD_ANALYTE_TEST_REFERENCE_RANGE MyEntity = new STD_ANALYTE_TEST_REFERENCE_RANGE();

            //MyEntity = SelectReferenceRangeByID2(RefRange.ID);

            using (_db = GetDataContext())
            {
                //SetLoadWith(_db);

                MyEntity = (from e in LinqAll()
                            where e.ID == RefRange.ID
                        select e).FirstOrDefault();

                //2. change the values in there

                MyEntity.REFERENCE_RANGE = RefRange.TEFSCReferenceRange;

                //3. Get the Unit object for the newly selected unit

                STD_UNIT MyUnit = new STD_UNIT();


                MyUnit = (from e in _db.STD_UNITs
                          where e.ID == RefRange.UnitID
                          select e).FirstOrDefault();

                MyEntity.STD_UNIT = MyUnit;

                //3. update commit

                _db.SubmitChanges();

            }
        }

        #endregion

        #region Views

        public class ReferenceRangeView
        {
            public int ID { get; set; }
            public string TestName { get; set; }
            public string AnalyteName { get; set; }
            public string TEFSCReferenceRange { get; set; }
            public int UnitID { get; set; }
            public string UnitName { get; set; }
        }

        #endregion

    }
}
